/*
 * Decompiled with CFR 0.152.
 */
package prog.gui.anal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import prog.core.aln.mut.MutationSpot;
import prog.core.index.Index;
import prog.gui.anal.Anal;
import prog.gui.anal.Main;
import prog.gui.anal.ViewPoint;

public class AnalSub
extends ViewPoint {
    private static DecimalFormat df = new DecimalFormat("#.###");
    private static DecimalFormat df1p = new DecimalFormat("#.#");
    public String tag;
    public ArrayList<MutationSpot> muts;
    public DefaultTableModel tm;

    public AnalSub(Anal mut, String tag, ArrayList<MutationSpot> muts, Index index) {
        super(mut);
        this.tag = tag;
        this.muts = muts;
        try {
            Object[][] ss = new String[muts.size()][7];
            for (int i = 0; i < muts.size(); ++i) {
                MutationSpot m = muts.get(i);
                ss[i][0] = m.gene();
                ss[i][1] = m.toString();
                ss[i][2] = m.aminoAcidMutation(index);
                ss[i][3] = Integer.toString(m.mutReads.size());
                ss[i][4] = df1p.format(m.wtReads.size());
                ss[i][5] = df.format(m.vaf());
                ss[i][6] = m.label;
            }
            this.tm = new DefaultTableModel(ss, new String[]{"Gene", "Mutation", "AminoAcid", "MutReads", "WTReads", "VAF", "Type"}){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected JComponent createComponent() {
        JTable t = new JTable(this.tm);
        JScrollPane jsp = new JScrollPane(t);
        return jsp;
    }

    public void render() {
        this.reloadComponents();
        ((Main)this.getTopParent()).gui().mainPan.setJSPRight(this.comp);
    }

    public void writeToFile(File out) throws Exception {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("Gene\tMutation\tProtMut\tMutReads\tWTReads\tVAF\n");
        for (int i = 0; i < this.tm.getRowCount(); ++i) {
            for (int j = 0; j < this.tm.getColumnCount(); ++j) {
                bw.write((String)this.tm.getValueAt(i, j) + "\t");
            }
            bw.write("\n");
        }
        bw.close();
    }
}

