/*
 * Decompiled with CFR 0.152.
 */
package prog.gui.anal;

import fork.lib.gui.soft.gen.util.FAnalysis;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import prog.core.index.Index;
import prog.gui.MainGui;
import prog.gui.anal.Anal;
import prog.gui.anal.FTreeNode;

public class Main
extends FAnalysis {
    private MainGui gui;
    private JTree tree;

    public Main(MainGui gui) {
        super(null);
        this.gui = gui;
    }

    public MainGui gui() {
        return this.gui;
    }

    protected void destroy() {
    }

    public void reloadComponents() {
        int ind;
        try {
            ind = this.tree == null ? 3 : this.tree.getSelectionRows()[0];
        }
        catch (Exception e) {
            ind = 0;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Analyses");
        DefaultTreeModel treemod = new DefaultTreeModel(root);
        this.tree = new JTree(treemod);
        for (FAnalysis ch : this.children) {
            Anal anal = (Anal)ch;
            treemod.insertNodeInto(anal.node, root, root.getChildCount());
        }
        this.tree.getSelectionModel().setSelectionMode(1);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setSelectionRow(ind);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    FTreeNode n = (FTreeNode)Main.this.tree.getLastSelectedPathComponent();
                    Anal an = (Anal)n.anal();
                    an.list.setSelectedIndex(1);
                    ((FAnalysis)an.children().get(1)).reRenderChain();
                    an.reRenderChain();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void render() {
        JTabbedPane ttl = new JTabbedPane();
        ttl.addTab("Project", this.tree);
        this.gui.mainPan.setJSPTopLeft((JComponent)ttl);
    }

    public void addAnal(String tag, String dir, String poolpath, String alnpath, String corrpath, String oncopath, Index index) {
        Anal an = new Anal(this, tag, dir, poolpath, alnpath, corrpath, oncopath, index);
        try {
            this.tree.setSelectionPath(new TreePath(an.node));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        MainGui.main(args);
    }

    public String helpMsg() {
        return "You need FASTQ file(s) from RNA-seq an experiment to start a new analysis.\n";
    }
}

