/*
 * Decompiled with CFR 0.152.
 */
package prog.gui.checker;

import fork.lib.bio.seq.parser.fastq.FastqEntry;
import fork.lib.bio.seq.parser.fastq.FastqReader;
import fork.lib.gui.soft.gen.util.Checker;
import java.io.File;
import java.util.HashSet;

public class FastqChecker
extends Checker {
    protected String fq;
    protected HashSet<Character> allow = new HashSet();

    public FastqChecker(String fa) {
        this.fq = fa;
        this.allow.add(Character.valueOf('A'));
        this.allow.add(Character.valueOf('T'));
        this.allow.add(Character.valueOf('C'));
        this.allow.add(Character.valueOf('G'));
        this.allow.add(Character.valueOf('a'));
        this.allow.add(Character.valueOf('t'));
        this.allow.add(Character.valueOf('c'));
        this.allow.add(Character.valueOf('g'));
        this.allow.add(Character.valueOf('N'));
        this.allow.add(Character.valueOf('n'));
    }

    public void check() {
        FastqEntry en;
        FastqReader fr;
        Checker.checkFileExit((Checker)this, (String)this.fq, (char)MODE_ERROR, null);
        if (this.ifError()) {
            return;
        }
        try {
            fr = new FastqReader(this.fq);
        }
        catch (Exception e) {
            this.appendErrorMessage("File " + this.fq + " is not FASTQ format.\n");
            return;
        }
        int n = 0;
        while ((en = fr.nextEntry()) != null && ++n <= 100) {
            String s = en.sequence();
            boolean isseq = true;
            for (int i = 0; i < s.length(); ++i) {
                if (this.allow.contains(Character.valueOf(s.charAt(i)))) continue;
                isseq = false;
                break;
            }
            if (isseq) continue;
            this.appendErrorMessage("Fastq file looks incorrect: " + new File(this.fq).getName() + "\n  sequence: " + s.substring(0, Math.min(s.length(), 20)) + "\n");
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        FastqChecker c = new FastqChecker("C:\\muxingu\\data\\own\\SangerSoftware2\\file/hotspot_TCGA-AB-2984.mut");
        c.check();
        System.out.println(c.errorMessage());
        System.out.println(c.warningMessage());
    }
}

