/*
 * Decompiled with CFR 0.152.
 */
package prog.gui.checker;

import fork.lib.bio.seq.parser.fastq.FastqEntry;
import fork.lib.bio.seq.parser.fastq.FastqReader;
import fork.lib.gui.soft.gen.util.Checker;
import prog.gui.checker.FastqChecker;

public class FastqPEChecker
extends Checker {
    protected String fa;
    protected String fb;

    public FastqPEChecker(String fa, String fb) {
        this.fa = fa;
        this.fb = fb;
    }

    public void check() {
        FastqEntry en1;
        FastqChecker fca = new FastqChecker(this.fa);
        FastqChecker fcb = new FastqChecker(this.fb);
        if (fca.ifError() || fcb.ifError()) {
            this.appendErrorMessage(fca.errorMessage());
            this.appendErrorMessage(fcb.errorMessage());
            return;
        }
        FastqReader fr1 = null;
        FastqReader fr2 = null;
        try {
            fr1 = new FastqReader(this.fa);
            fr2 = new FastqReader(this.fb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        int warnn = 0;
        boolean warnstart = false;
        while ((en1 = fr1.nextEntry()) != null) {
            String t2;
            FastqEntry en2 = fr2.nextEntry();
            if (en2 == null) {
                this.appendErrorMessage("Two files have different numbers of reads.\n");
                break;
            }
            if (++n > 500) break;
            String t1 = en1.ID();
            if (this.match(t1, t2 = en2.ID())) continue;
            if (!warnstart) {
                warnstart = true;
                this.appendWarningMessage("Read IDs do not seem paired:\n");
            }
            this.appendWarningMessage("    " + t1 + "    " + t2 + "\n");
            if (++warnn < 5) continue;
            break;
        }
        try {
            fr1.close();
            fr2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean match(String t1, String t2) {
        int l1 = t1.length();
        int l2 = t2.length();
        int lmin = Math.min(l1, l2);
        int m = 0;
        int mm = 0;
        for (int i = 0; i < lmin; ++i) {
            if (t1.charAt(i) == t2.charAt(i)) {
                ++m;
                continue;
            }
            ++mm;
        }
        return mm <= 3 && mm > 0;
    }

    public static void main(String[] args) throws Exception {
        FastqPEChecker c = new FastqPEChecker("C:\\muxingu\\data\\own\\SangerSoftware2\\file/GSM1636684_04H001_1.fq.gz", "C:\\muxingu\\data\\own\\SangerSoftware2\\file\\test_TCGA-AB-2984_2.fq.gz");
        c.check();
        System.out.println(c.errorMessage());
        System.out.println(c.warningMessage());
    }
}

