/*
 * Decompiled with CFR 0.152.
 */
package prog.gui.comp;

import fork.lib.base.collection.Predefined;
import fork.lib.gui.soft.gen.util.Checker;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import prog.Sys;
import prog.core.aln.res.oncofilt.PathogenicityFilter;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;
import prog.gui.checker.FastqChecker;
import prog.gui.checker.FastqPEChecker;
import prog.gui.checker.IndexChecker;
import prog.gui.checker.PathoChecker;

public class PanelNew
extends JPanel {
    private JDialog dialog;
    private boolean ifStart = false;
    private boolean ifpe;
    private File file1;
    private File file2;
    private Index index;
    private PathogenicityFilter pathofilter;
    private FileNameExtensionFilter extfilt = new FileNameExtensionFilter("FASTQ", "gz", "fq", "fastq");
    private boolean ifanal = false;
    private boolean iffq1 = false;
    private boolean iffq2 = false;
    private boolean ifind = false;
    private boolean ifonco = false;
    private HashSet<String> names = new HashSet();
    private ImageIcon icbad = new ImageIcon(Sys.IMG_CROSS_16);
    private ImageIcon icgood = new ImageIcon(Sys.IMG_TICK_16);
    private HashSet<Character> allowedChars = Predefined.alphaNumeric();
    private ButtonGroup bgroupSEPE;
    private JButton butCancel;
    private JButton butSelectFq1;
    private JButton butSelectFq2;
    private JButton butSelectInd;
    private JButton butSelectOnco;
    private JButton butStart;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jlanal;
    private JLabel jlfq1;
    private JLabel jlfq2;
    private JLabel jlind;
    private JLabel jlonco;
    private JRadioButton jrbPE;
    private JRadioButton jrbSE;
    private JTextField tfIndex;
    private JTextField tfName;
    private JTextField tfName1;
    private JTextField tfName2;
    private JTextField tfOnco;
    private JTextField tfanal;

    public PanelNew(JDialog dialog) {
        for (File f : new File(Sys.DIR_TEMP).listFiles()) {
            this.names.add(f.getName());
        }
        this.dialog = dialog;
        this.initComponents();
        this.allowedChars.add(Character.valueOf('_'));
        this.allowedChars.add(Character.valueOf('-'));
        this.tfName1.setText(Sys.FILE_DEMO1);
        this.tfName2.setText(Sys.FILE_DEMO2);
        this.tfIndex.setText(Sys.FILE_INDEX);
        this.tfOnco.setText(Sys.FILE_ONCO);
        this.setAnalText();
        this.jlanal.setSize(16, 16);
        this.jlanal.setText("");
        this.jlfq1.setSize(16, 16);
        this.jlfq1.setText("");
        this.jlfq2.setSize(16, 16);
        this.jlfq2.setText("");
        this.jlind.setSize(16, 16);
        this.jlind.setText("");
        this.jlonco.setSize(16, 16);
        this.jlonco.setText("");
        this.jlfq1.setIcon(this.icgood);
        this.jlfq2.setIcon(this.icgood);
        this.jlanal.setIcon(this.icgood);
        this.jlind.setIcon(this.icgood);
        this.jlonco.setIcon(this.icgood);
        this.tfanal.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!PanelNew.this.allowedChars.contains(Character.valueOf(c))) {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.tfanal.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelNew.this.checkAnal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelNew.this.checkAnal();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelNew.this.checkAnal();
            }
        });
        this.checkAnal();
        this.checkFq1();
        this.checkFq2();
        this.checkInd();
        this.checkOnco();
    }

    private void setAnalText() {
        String t;
        String t0 = "New_data";
        int i = 1;
        String string = t = i == 1 ? t0 : t0 + "_" + i;
        while (this.names.contains(t)) {
            t = ++i == 1 ? t0 : t0 + "_" + i;
        }
        this.tfanal.setText(t);
    }

    private void initComponents() {
        this.bgroupSEPE = new ButtonGroup();
        this.tfName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jrbSE = new JRadioButton();
        this.jrbPE = new JRadioButton();
        this.tfName1 = new JTextField();
        this.butSelectFq1 = new JButton();
        this.tfName2 = new JTextField();
        this.butSelectFq2 = new JButton();
        this.jLabel2 = new JLabel();
        this.tfIndex = new JTextField();
        this.butSelectInd = new JButton();
        this.butCancel = new JButton();
        this.butStart = new JButton();
        this.jLabel3 = new JLabel();
        this.tfanal = new JTextField();
        this.butSelectOnco = new JButton();
        this.jLabel4 = new JLabel();
        this.tfOnco = new JTextField();
        this.jlfq1 = new JLabel();
        this.jlfq2 = new JLabel();
        this.jlind = new JLabel();
        this.jlanal = new JLabel();
        this.jlonco = new JLabel();
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.tfNameActionPerformed(evt);
            }
        });
        this.setPreferredSize(new Dimension(400, 500));
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setText("Input Files:");
        this.bgroupSEPE.add(this.jrbSE);
        this.jrbSE.setText("Single-end");
        this.jrbSE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.jrbSEActionPerformed(evt);
            }
        });
        this.bgroupSEPE.add(this.jrbPE);
        this.jrbPE.setSelected(true);
        this.jrbPE.setText("Paired-end");
        this.jrbPE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.jrbPEActionPerformed(evt);
            }
        });
        this.tfName1.setEditable(false);
        this.tfName1.setBackground(new Color(255, 255, 255));
        this.tfName1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.tfName1ActionPerformed(evt);
            }
        });
        this.butSelectFq1.setText("Select");
        this.butSelectFq1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.butSelectFq1ActionPerformed(evt);
            }
        });
        this.tfName2.setEditable(false);
        this.tfName2.setBackground(new Color(255, 255, 255));
        this.tfName2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.tfName2ActionPerformed(evt);
            }
        });
        this.butSelectFq2.setText("Select");
        this.butSelectFq2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.butSelectFq2ActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("Gene Index:");
        this.tfIndex.setEditable(false);
        this.tfIndex.setBackground(new Color(255, 255, 255));
        this.tfIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.tfIndexActionPerformed(evt);
            }
        });
        this.butSelectInd.setText("Select");
        this.butSelectInd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.butSelectIndActionPerformed(evt);
            }
        });
        this.butCancel.setText("Cancel");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.butCancelActionPerformed(evt);
            }
        });
        this.butStart.setText("Start");
        this.butStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.butStartActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 1, 13));
        this.jLabel3.setText("Analysis Name");
        this.tfanal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.tfanalActionPerformed(evt);
            }
        });
        this.butSelectOnco.setText("Select");
        this.butSelectOnco.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.butSelectOncoActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Tahoma", 1, 13));
        this.jLabel4.setText("Oncogenicty Filter:");
        this.tfOnco.setEditable(false);
        this.tfOnco.setBackground(new Color(255, 255, 255));
        this.tfOnco.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelNew.this.tfOncoActionPerformed(evt);
            }
        });
        this.jlfq1.setText(".");
        this.jlfq2.setText(".");
        this.jlind.setText(".");
        this.jlanal.setText(".");
        this.jlonco.setText(".");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jrbSE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jrbPE)).addGroup(layout.createSequentialGroup().addGap(114, 114, 114).addComponent(this.butStart, -2, 79, -2).addGap(36, 36, 36).addComponent(this.butCancel, -2, 79, -2)).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.tfanal, -2, 308, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlanal, -2, 16, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(layout.createSequentialGroup().addComponent(this.tfOnco, -2, 308, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlonco, -2, 16, -2)).addGroup(layout.createSequentialGroup().addComponent(this.tfName1, -2, 308, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlfq1, -2, 16, -2)).addGroup(layout.createSequentialGroup().addComponent(this.tfName2, -2, 308, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlfq2, -2, 16, -2)).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.tfIndex, -2, 308, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlind, -2, 16, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.butSelectOnco, -2, 79, -2).addComponent(this.butSelectFq1, -2, 79, -2).addComponent(this.butSelectInd, -2, 79, -2).addComponent(this.butSelectFq2, -2, 79, -2)))).addContainerGap(28, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfanal, -2, -1, -2).addComponent(this.jlanal)).addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jrbSE).addComponent(this.jrbPE)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfName1, -2, -1, -2).addComponent(this.jlfq1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfName2, -2, -1, -2).addComponent(this.jlfq2).addComponent(this.butSelectFq2)).addGap(13, 13, 13).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfIndex, -2, -1, -2).addComponent(this.jlind)).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfOnco, -2, -1, -2).addComponent(this.jlonco))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.butSelectInd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.butSelectOnco))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 94, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.butStart).addComponent(this.butCancel))).addGroup(layout.createSequentialGroup().addComponent(this.butSelectFq1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jrbSE.getAccessibleContext().setAccessibleName("jrbSE");
    }

    private void jrbSEActionPerformed(ActionEvent evt) {
        this.groupButt();
    }

    private void tfNameActionPerformed(ActionEvent evt) {
    }

    private void tfName1ActionPerformed(ActionEvent evt) {
    }

    private void butSelectFq1ActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        File f = null;
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Select File");
        jfc.setCurrentDirectory(new File(Sys.pref.fastqDirectory()));
        jfc.setFileFilter(this.extfilt);
        this.setCursor(new Cursor(0));
        int returnVal = jfc.showOpenDialog(this.dialog);
        if (returnVal == 0) {
            f = jfc.getSelectedFile();
        }
        if (f != null) {
            this.tfName1.setText(f.getAbsolutePath());
            Sys.pref.setFastqDirectory(f.getAbsoluteFile().getParentFile().getPath());
            this.checkFq1();
        }
    }

    private void tfName2ActionPerformed(ActionEvent evt) {
    }

    private void butSelectFq2ActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        File f = null;
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Select File");
        jfc.setCurrentDirectory(new File(Sys.pref.fastqDirectory()));
        jfc.setFileFilter(this.extfilt);
        this.setCursor(new Cursor(0));
        int returnVal = jfc.showOpenDialog(this.dialog);
        if (returnVal == 0) {
            f = jfc.getSelectedFile();
        }
        if (f != null) {
            this.tfName2.setText(f.getAbsolutePath());
            Sys.pref.setFastqDirectory(f.getAbsoluteFile().getParentFile().getPath());
            this.checkFq2();
        }
    }

    private void tfIndexActionPerformed(ActionEvent evt) {
    }

    private void butSelectIndActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        File f = null;
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Select Index");
        jfc.setCurrentDirectory(new File(Sys.pref.indexDirectory()));
        jfc.setFileFilter(new FileNameExtensionFilter("Index", "ind"));
        this.setCursor(new Cursor(0));
        int returnVal = jfc.showOpenDialog(this.dialog);
        if (returnVal == 0) {
            f = jfc.getSelectedFile();
        }
        if (f != null) {
            this.tfIndex.setText(f.getAbsolutePath());
            Sys.pref.setIndexDirectory(f.getAbsoluteFile().getParentFile().getPath());
            this.checkInd();
        }
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.dialog.dispose();
    }

    private void butStartActionPerformed(ActionEvent evt) {
        this.ifpe = this.jrbPE.isSelected();
        this.setCursor(new Cursor(3));
        if (!(this.ifanal && this.iffq1 && this.iffq2 && this.ifind && this.ifonco)) {
            JOptionPane.showMessageDialog(this.dialog, "Some areas are incorrect!", "Error", 0);
            return;
        }
        this.file1 = new File(this.tfName1.getText());
        this.file2 = new File(this.tfName2.getText());
        FastqPEChecker ch = new FastqPEChecker(this.file1.getAbsolutePath(), this.file2.getAbsolutePath());
        try {
            ch.check();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ch.ifError()) {
            JOptionPane.showMessageDialog(this.dialog, ch.errorMessage(), "Error", 0);
            return;
        }
        int v = 0;
        if (this.ifpe && ch.ifWarning()) {
            v = JOptionPane.showConfirmDialog(this.dialog, ch.warningMessage() + "\nDo you want to continue?", "Warning", 2, 2);
        }
        if (v == 2) {
            this.setCursor(new Cursor(0));
            return;
        }
        try {
            this.index = IndexBuilder.read(this.tfIndex.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.dialog, "Can't read index. Please download the software again.", "Error", 0);
            this.setCursor(new Cursor(0));
            return;
        }
        this.ifStart = true;
        this.setCursor(new Cursor(0));
        this.dialog.dispose();
    }

    private void jrbPEActionPerformed(ActionEvent evt) {
        this.groupButt();
    }

    private void tfanalActionPerformed(ActionEvent evt) {
    }

    private void butSelectOncoActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        File f = null;
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Select Oncogenicity Filter");
        jfc.setCurrentDirectory(new File(Sys.pref.pathoDirectory()));
        jfc.setFileFilter(new FileNameExtensionFilter("Oncogenicity Filter", "txt"));
        this.setCursor(new Cursor(0));
        int returnVal = jfc.showOpenDialog(this.dialog);
        if (returnVal == 0) {
            f = jfc.getSelectedFile();
        }
        if (f != null) {
            this.tfOnco.setText(f.getAbsolutePath());
            Sys.pref.setPathoDirectory(f.getAbsoluteFile().getParentFile().getPath());
            try {
                this.checkOnco();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void tfOncoActionPerformed(ActionEvent evt) {
    }

    public void groupButt() {
        if (this.jrbSE.isSelected()) {
            this.jlfq2.setVisible(false);
            this.tfName2.setEnabled(false);
            this.tfName2.setBackground(new Color(240, 240, 240));
            this.butSelectFq2.setEnabled(false);
        } else if (this.jrbPE.isSelected()) {
            this.jlfq2.setVisible(true);
            this.tfName2.setEnabled(true);
            this.tfName2.setBackground(Color.white);
            this.butSelectFq2.setEnabled(true);
        }
    }

    public boolean ifStart() {
        return this.ifStart;
    }

    public boolean ifPE() {
        return this.ifpe;
    }

    public File file_1() {
        return this.file1;
    }

    public File file_2() {
        return this.file2;
    }

    public Index index() {
        return this.index;
    }

    public String analName() {
        return this.tfanal.getText();
    }

    public PathogenicityFilter pathoFilter() {
        return this.pathofilter;
    }

    public void check(Checker ch, JLabel jl) {
        if (ch.ifError()) {
            JOptionPane.showMessageDialog(this.dialog, ch.errorMessage(), "Error", 0);
            jl.setIcon(this.icbad);
        } else {
            jl.setIcon(this.icgood);
        }
    }

    private void checkAnal() {
        String s = this.tfanal.getText();
        if (this.names.contains(s)) {
            this.jlanal.setIcon(this.icbad);
            this.ifanal = false;
        } else {
            this.jlanal.setIcon(this.icgood);
            this.ifanal = true;
        }
    }

    private void checkFq1() {
        FastqChecker ch = new FastqChecker(this.tfName1.getText());
        ch.check();
        this.check(ch, this.jlfq1);
        this.iffq1 = !ch.ifError();
    }

    private void checkFq2() {
        FastqChecker ch = new FastqChecker(this.tfName2.getText());
        ch.check();
        this.check(ch, this.jlfq2);
        this.iffq2 = !ch.ifError();
    }

    private void checkInd() {
        IndexChecker ch = new IndexChecker(this.tfIndex.getText());
        ch.check();
        this.check(ch, this.jlind);
        this.ifind = !ch.ifError();
    }

    private void checkOnco() {
        PathoChecker ch = new PathoChecker(this.tfOnco.getText());
        try {
            ch.check();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.check(ch, this.jlonco);
        if (!ch.ifError()) {
            try {
                this.pathofilter = new PathogenicityFilter(this.tfOnco.getText());
                this.ifonco = !ch.ifError();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.dialog, "Cannot read oncogenicity file. Please download the software again.", "Error", 0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        JDialog d = new JDialog();
        PanelNew pan = new PanelNew(d);
        d.setModal(true);
        d.setContentPane(pan);
        d.setSize(new Dimension(500, 600));
        d.setVisible(true);
        System.out.println(pan.ifStart());
        System.out.println(pan.index());
    }
}

