/*
 * Decompiled with CFR 0.152.
 */
package snippet;

import fork.lib.base.Counter;
import fork.lib.base.file.FileName;
import fork.lib.bio.seq.Nucleotide;
import fork.lib.bio.seq.parser.fastq.FastqEntry;
import fork.lib.bio.seq.parser.fastq.FastqReader;
import fork.lib.bio.seq.parser.fastq.FastqWriter;

public class CheckSeqManualPTD {
    public static int sidemin = 12;
    public static int sidemax = 15;

    public static void main(String[] args) throws Exception {
        String dir = "C:/muxingu/data/own/SangerSoftware2/file";
        String tar1 = "AAAATTCCAGCAGATGGAGTCCACAGGATCAGAGTGGACTTTAAG";
        String tar2 = "GATGAGCAATTCTTAGGTTTTGGCTCAGATGAAGAAGTCAGAGTG";
        String tarr1 = Nucleotide.reverseComplement((String)tar1);
        String tarr2 = Nucleotide.reverseComplement((String)tar2);
        String samp = "TCGA-AB-2948";
        String[] infns = new String[]{dir + "/" + samp + "_1.fq.gz", dir + "/" + samp + "_2.fq.gz"};
        Counter cc = new Counter(1000000);
        FastqWriter fw = new FastqWriter(dir + "/manual-pg_" + samp + ".fq", false);
        for (String inf : infns) {
            FastqEntry en;
            FastqReader fr;
            FastqReader fastqReader = fr = FileName.extension((String)inf).equals("gz") ? new FastqReader(inf, true) : new FastqReader(inf);
            while ((en = fr.nextEntry()) != null) {
                cc.count();
                String seq = en.sequence();
                if (tar1.contains(seq.substring(0, sidemax))) {
                    if (!tar2.contains(seq.substring(seq.length() - sidemin))) continue;
                    fw.write(en);
                    continue;
                }
                if (tarr1.contains(seq.substring(0, sidemax))) {
                    if (!tarr2.contains(seq.substring(seq.length() - sidemin))) continue;
                    fw.write(en);
                    continue;
                }
                if (tar2.contains(seq.substring(0, sidemax))) {
                    if (!tar1.contains(seq.substring(seq.length() - sidemin))) continue;
                    fw.write(en);
                    continue;
                }
                if (!tarr2.contains(seq.substring(0, sidemax)) || !tarr1.contains(seq.substring(seq.length() - sidemin))) continue;
                fw.write(en);
            }
        }
        fw.close();
    }
}

