/*
 * Decompiled with CFR 0.152.
 */
package snippet;

import java.io.File;
import java.io.PrintWriter;
import prog.core.Param;
import prog.core.aln.Aligner;
import prog.core.aln.hot.DetectorFusion;
import prog.core.aln.hot.DetectorFusionPair;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class Detect {
    public static void main(String[] args) throws Exception {
        String indexf = "index_pml-rara.ind";
        File root = new File("/nfs/users/nfs_m/mg31/data/inhouse/billy/20200212_pml-rara");
        File dir = new File(root + "/rnamut");
        String tag = args[0];
        if (args.length == 0) {
            args = new String[]{tag};
        } else {
            tag = args[0];
        }
        String[] infns = new String[]{root + "/fastq/" + tag + "_1.fq.gz", root + "/fastq/" + tag + "_2.fq.gz"};
        Index index = IndexBuilder.read(dir + "/" + indexf);
        System.out.println("Index loaded. ");
        PrintWriter wr = new PrintWriter(System.out);
        Param par = new Param();
        par.fusionFirstRunMinCount = 2;
        par.fusionSecondRunMinCount = 2;
        par.fusionPEMinCount = 2;
        String alnpath = dir + "/pool/align_" + tag + ".aln";
        String poolpath = dir + "/pool/pool_" + tag + ".rds";
        Aligner alner = infns.length == 2 ? Aligner.AlignFastqPE(infns, poolpath, index, par, wr) : Aligner.AlignFastqSE(infns, poolpath, index, par, wr);
        AlignmentResult res = alner.result();
        res.write(alnpath);
        ReadPool pool = ReadPool.read(poolpath);
        System.out.println("Pool Read.");
        AlignmentResult res2 = AlignmentResult.read(alnpath, index, pool);
        MutationResult mres = new MutationResult();
        DetectorFusion ff = new DetectorFusion(res2, index, pool, par);
        ff.start();
        mres.addAll(ff.result());
        DetectorFusionPair fp = new DetectorFusionPair(res2, index, pool, par);
        fp.start();
        mres.addAll(fp.result());
        MutationResult.writeToTxtFile(mres, index, pool, dir + "/out/hotspot_" + tag + ".txt", false);
        MutationResult.ifprint = true;
        MutationResult.writeToTxtFile(mres, index, pool, dir + "/out/hotspot-all_" + tag + ".txt", false);
    }
}

