/*
 * Decompiled with CFR 0.152.
 */
package snippet;

import fork.lib.base.collection.Pair;
import fork.lib.base.file.FileName;
import fork.lib.bio.seq.parser.fastq.FastqEntry;
import fork.lib.bio.seq.parser.fastq.FastqReader;
import fork.lib.bio.seq.parser.fastq.FastqWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import prog.core.Param;
import prog.core.aln.hot.DetectorFusion;
import prog.core.aln.hot.DetectorFusionPair;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.hot.DetectorITD;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotFusionPair;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class GenerateDemo {
    public static void main(String[] args) throws Exception {
        FastqEntry en1;
        FastqReader fr2;
        String dir = "C:/muxingu/data/own/SangerSoftware2/file";
        String tag = "TCGA-AB-2925";
        String[] infns = new String[]{dir + "/" + tag + "_1.fq.gz", dir + "/" + tag + "_2.fq.gz"};
        FastqWriter fwa = new FastqWriter(dir + "/Demo_1.fq.gz", true);
        FastqWriter fwb = new FastqWriter(dir + "/Demo_2.fq.gz", true);
        Index index = IndexBuilder.read(dir + "/index.ind");
        System.out.println("Index loaded. ");
        PrintWriter wr = new PrintWriter(System.out);
        Param par = new Param();
        String alnpath = dir + "/pool/align_" + tag + ".aln";
        String poolpath = dir + "/pool/pool_" + tag + ".rds";
        ReadPool pool = ReadPool.read(poolpath);
        System.out.println("Pool Read.");
        AlignmentResult res2 = AlignmentResult.read(alnpath, index, pool);
        DetectorHotspot hs = new DetectorHotspot(res2, index, pool, par);
        hs.start();
        DetectorITD dd = new DetectorITD(res2, index, pool, par);
        dd.start();
        DetectorFusion ff = new DetectorFusion(res2, index, pool, par);
        ff.start();
        DetectorFusionPair fp = new DetectorFusionPair(res2, index, pool, par);
        fp.start();
        MutationResult mres = new MutationResult();
        mres.addAll(hs.result());
        mres.addAll(dd.result());
        mres.addAll(ff.result());
        mres.addAll(fp.result());
        HashSet<String> ids = new HashSet<String>();
        for (MutationSpot m : mres.allMutations()) {
            for (Read read : m.wtReads(pool)) {
                ids.add(read.id());
            }
            for (Read read : m.mutatedReads(pool)) {
                ids.add(read.id());
            }
            if (!(m instanceof MutationSpotFusionPair)) continue;
            MutationSpotFusionPair mp = (MutationSpotFusionPair)m;
            for (Pair<Integer, Integer> pair : mp.reads) {
            }
        }
        FastqReader fr1 = FileName.extension((String)infns[0]).equals("gz") ? new FastqReader(infns[0], true) : new FastqReader(infns[0]);
        FastqReader fastqReader = fr2 = FileName.extension((String)infns[1]).equals("gz") ? new FastqReader(infns[1], true) : new FastqReader(infns[1]);
        while ((en1 = fr1.nextEntry()) != null) {
            FastqEntry fastqEntry = fr2.nextEntry();
            if (!ids.contains(en1.ID()) && !ids.contains(fastqEntry.ID())) continue;
            fwa.write(en1);
            fwb.write(fastqEntry);
        }
        fwa.close();
        fwb.close();
    }
}

