/*
 * Decompiled with CFR 0.152.
 */
package snippet.indext;

import fork.lib.bio.seq.parser.fasta.FastaEntry;
import fork.lib.bio.seq.parser.fasta.FastaReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import prog.core.index.IndexBuilderFasta;

public class CustomIndex {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Error: not enough args\nUsage: GENE_DIR  OUT_FILE(.ind)  TARGET_GENES(,)  ITD_GENES(,)  FUSION_GENE_PAIRS(-,)");
            System.err.println("Example: java -Xmx500m -cp SangerSoftware2.jar snippet.indext.CustomIndex  ./genes ./custom.ind   NPM1,FLT3,TET2  FLT3,KMT2A  KMT2A-ELL");
        }
        String dir = args[0];
        String out = args[1];
        String tars = args[2];
        String itds = args.length > 3 ? args[3] : null;
        String fus = args.length > 4 ? args[4] : null;
        HashSet<String> allgenes = new HashSet<String>();
        allgenes.addAll(Arrays.asList(tars.split(",")));
        allgenes.addAll(Arrays.asList(itds.split(",")));
        for (String gc : fus.split(",")) {
            for (String g : gc.split("-")) {
                allgenes.add(g);
            }
        }
        ArrayList<FastaEntry> ens = new ArrayList<FastaEntry>();
        for (String gn : allgenes) {
            if (gn.equals("")) continue;
            gn = gn.replace(" ", "");
            gn = gn.replace("\t", "");
            File f = new File(dir + "/" + gn.toUpperCase() + ".fa");
            if (f.exists()) {
                FastaReader fr = new FastaReader(f);
                ens.add(fr.nextEntry());
                continue;
            }
            System.err.println("Error: file not found " + f.getAbsolutePath() + " - not indexed");
        }
        IndexBuilderFasta bb = new IndexBuilderFasta(ens);
        bb.build();
        if (tars != null) {
            if (tars.equals("-")) {
                bb.addTargetGenesAll();
            } else {
                bb.addTargetGenes(tars.split(","));
            }
        }
        if (itds != null && !itds.equals("-")) {
            bb.addItdGenes(itds.split(","));
        }
        if (fus != null && !fus.equals("-")) {
            bb.addFusionPairs(fus.split(","));
        }
        bb.write(out);
        System.out.println("Success: output written to " + new File(out).getAbsolutePath());
    }
}

