/*
 * Decompiled with CFR 0.152.
 */
package snippet.indext;

import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.bio.seq.parser.fasta.FastaEntry;
import fork.lib.bio.seq.parser.fasta.FastaReader;
import fork.lib.bio.seq.parser.fasta.FastaWriter;
import fork.lib.bio.seq.parser.gtfgff.GtfLine;
import fork.lib.bio.seq.parser.gtfgff.GtfReader;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.Gene;
import fork.lib.bio.seq.region.Transcript;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public class GenerateFastas {
    public static void main(String[] args) throws Exception {
        File f = new File("C:\\muxingu\\genome\\human\\grch38/ass/Homo_sapiens.GRCh38.93_pc.gtfmin");
        File spldir = new File("C:\\muxingu\\genome\\human\\grch38\\fasta/chr");
        HashSet ccds = new HashSet();
        ccds.addAll(new ReadTable("C:\\muxingu\\genome\\human\\grch38\\ass/mart_export_with-ccds.txt").getColumnArray(1));
        File outdir = new File("C:\\muxingu/data/own/SangerSoftware2/custom_index/genes");
        outdir.mkdirs();
        HashMap chrgs = new HashMap();
        GtfReader grd = new GtfReader(f);
        GenomicRegionsBuilder gb = grd.genomicRegionsBuilder();
        for (Object gr : gb) {
            Gene gene = (Gene)gr;
            ArrayList<Transcript> trs = new ArrayList<Transcript>();
            for (Transcript tr : gene.children()) {
                GtfLine gl = (GtfLine)tr.attr();
                if (!ccds.contains(gl.getField(GtfLine.FIELD_TRANSCRIPT_ID))) continue;
                trs.add(tr);
            }
            if (trs.isEmpty()) continue;
            Collections.sort(trs, new Comparator<Transcript>(){

                @Override
                public int compare(Transcript o1, Transcript o2) {
                    return Integer.compare(o2.cdsLength(), o1.cdsLength());
                }
            });
            ArrayList ntrs = new ArrayList();
            ntrs.add(trs.get(0));
            Gene ngene = new Gene(gene.chr(), gene.strand(), ntrs);
            ngene.setAttribute(gene.attr());
            if (!chrgs.containsKey(ngene.chr())) {
                chrgs.put(ngene.chr(), new ArrayList());
            }
            ((ArrayList)chrgs.get(ngene.chr())).add(ngene);
        }
        HashSet<String> set = new HashSet<String>();
        for (String chr : chrgs.keySet()) {
            FastaReader fr = new FastaReader(spldir + "/chr" + chr + ".txt");
            System.out.println(chr);
            String chrseq = fr.nextEntry().sequence();
            for (Gene gene : (ArrayList)chrgs.get(chr)) {
                for (Transcript tr : gene.children()) {
                    String cds = gene.isOnForwardStrand() ? tr.lowPoint() + "," + (tr.highPoint() + 3) : tr.lowPoint() - 3 + "," + tr.highPoint();
                    String tit = tr.getID() + "_" + gene.name() + " chr" + tr.chr() + " " + tr.strand() + " " + cds + " ";
                    for (DirectionalGenomicRegion ex : tr.children()) {
                        tit = tit + (int)ex.low() + "-" + (int)ex.high() + ",";
                    }
                    String seq = tr.sequence(chrseq);
                    FastaWriter fw = new FastaWriter(outdir + "/" + gene.name() + ".fa");
                    fw.param().charPerLine = Integer.MAX_VALUE;
                    fw.write(new FastaEntry(tit, seq));
                    fw.close();
                    set.add(gene.name());
                }
            }
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter("C:\\muxingu/data/own/SangerSoftware2/custom_index/genelist.txt"));
        for (String s : set) {
            bw.write(s + "\n");
        }
        bw.close();
    }
}

