/*
 * Decompiled with CFR 0.152.
 */
package snippet.sim;

import fork.lib.base.Counter;
import fork.lib.base.FTimer;
import fork.lib.base.collection.Pair;
import fork.lib.bio.seq.parser.fasta.FastaEntry;
import fork.lib.bio.seq.parser.fasta.FastaReader;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import prog.core.Param;
import prog.core.aln.Aligner;
import prog.core.aln.Alignment;
import prog.core.aln.ReadAligner;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;
import snippet.sim.Pileup;

public class MapAllWindows {
    private static Aligner alignPE(String[] infns, String poolpath, Index index, Param par) throws Exception {
        FastaEntry en1;
        HashSet<String> gns = new HashSet<String>();
        gns.addAll(Arrays.asList("U2AF1L5", "CLEC2D", "MFSD11", "NDE1", "CDC42SE1"));
        ReadPool fw = new ReadPool(poolpath);
        Aligner alner = new Aligner(index, par);
        FastaReader fr1 = new FastaReader(infns[0], true);
        FastaReader fr2 = new FastaReader(infns[1], true);
        int id = -1;
        Counter cc = new Counter(1000000, "", " paired-end reads mapped... ", (Writer)new PrintWriter(System.out), new FTimer());
        while ((en1 = fr1.nextEntry()) != null) {
            String ga;
            Read rd2;
            String gid = en1.title().split("_")[0];
            if (gns.contains(gid)) continue;
            id += 2;
            if (par.ifVerbose) {
                cc.count();
            }
            FastaEntry en2 = fr2.nextEntry();
            Read rd1 = new Read(id, en1.title(), en1.sequence(), "", par);
            if (rd1.length() < par.minReadLength || (rd2 = new Read(id + 1, en2.title(), en2.sequence(), "", par)).length() < par.minReadLength) continue;
            par.readlens.add((Object)rd1.length());
            par.readlens.add((Object)rd2.length());
            ReadAligner rdalner1 = new ReadAligner(rd1, index, par);
            ReadAligner rdalner2 = new ReadAligner(rd2, index, par);
            ArrayList<Alignment> alns1 = rdalner1.alignments();
            ArrayList<Alignment> alns2 = rdalner2.alignments();
            Pair<Alignment, Alignment> bpair = Aligner.bestPair(alns1, alns2, par);
            if (bpair == null) {
                if (Aligner.addToPairedTranslocation(alner, alns1, alns2, rd1, rd2, index, par, fw)) {
                    Aligner.addToPairedTranslocation(alner, alns1, alns2, rd1, rd2, index, par, fw);
                    continue;
                }
                if (rdalner1.bestAlignment() == null) {
                    if (!Aligner.addToResultITD(alner, rd1, rdalner1, index, par, fw)) {
                        Aligner.addToReadTranslocation(alner, rd1, rdalner1, index, par, fw, true);
                    } else {
                        Aligner.addToResultITD(alner, rd1, rdalner1, index, par, fw);
                    }
                }
                if (rdalner2.bestAlignment() != null) continue;
                if (!Aligner.addToResultITD(alner, rd2, rdalner2, index, par, fw)) {
                    Aligner.addToReadTranslocation(alner, rd2, rdalner2, index, par, fw, true);
                    continue;
                }
                Aligner.addToResultITD(alner, rd2, rdalner2, index, par, fw);
                continue;
            }
            Alignment aln1 = (Alignment)bpair.a();
            Alignment aln2 = (Alignment)bpair.b();
            if (aln1 == null || aln2 == null || (ga = aln1.geneID()).equals(gid)) continue;
            Aligner.addToResult(alner, new Alignment[]{aln1, aln2}, new ReadAligner[]{rdalner1, rdalner2}, index, par, fw);
        }
        fw.close();
        fr1.close();
        fr2.close();
        return alner;
    }

    public static void main(String[] args) throws Exception {
        String root = args[0];
        String simdir = args[1];
        String indexdir = args[2];
        String outdir = args[3];
        String lentag = args[4];
        String indtag = args[5];
        String[] infs = new String[]{simdir + "/allwindow_" + lentag + "_1.fa.gz", simdir + "/allwindow_" + lentag + "_2.fa.gz"};
        Index index = IndexBuilder.read(indexdir + "/" + indtag + ".ind");
        Param par = new Param();
        par.maxMutationsPerTranscript = 1;
        par.maxMutatedBases = 2;
        par.peMaxFragmentSize = 300;
        par.ifAlignEnds = true;
        String alnpath = root + "/temp/pool/align_" + lentag + "_" + indtag + ".aln";
        String poolpath = root + "/temp/pool/pool_" + lentag + "_" + indtag + ".rds";
        new File(alnpath).getParentFile().mkdirs();
        Aligner alner = MapAllWindows.alignPE(infs, poolpath, index, par);
        AlignmentResult res = alner.result();
        res.write(alnpath);
        ReadPool pool = ReadPool.read(poolpath);
        AlignmentResult res2 = AlignmentResult.read(alnpath, index, pool);
        Pileup pp = new Pileup();
        pp.addAlignmentResult(res2);
        pp.writeToWig(outdir + "/" + lentag + "_" + indtag + ".wig");
        try {
            new File(alnpath).delete();
            new File(poolpath).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

