/*
 * Decompiled with CFR 0.152.
 */
package snippet.sim;

import fork.lib.bio.seq.parser.bedgraph.BedGraphExporter;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import prog.core.aln.Alignment;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.mut.AlignedElement;
import prog.core.aln.res.AlignmentResult;

public class Pileup
extends HashMap<String, HashMap<Integer, Integer>> {
    public void addAlignmentResult(AlignmentResult res) {
        for (String gid : res.alignmentResult().keySet()) {
            for (Alignment aln : res.resread.getAlignmentsForGene(gid)) {
                this.addAlignment(aln);
            }
        }
    }

    public void addAlignment(Alignment aln) {
        for (AlignedElement ele : aln.elements()) {
            this.addAlignedElement(ele, aln.isoformStrand());
        }
    }

    public void addAlignedElement(AlignedElement ele, IsoformStrand iso) {
        if (ele == null) {
            return;
        }
        Region reg = ele.referenceRegion();
        if (reg == null) {
            return;
        }
        String chr = iso.geneID();
        if (!this.containsKey(chr)) {
            this.put(chr, new HashMap());
        }
        HashMap pv = (HashMap)this.get(chr);
        int l = (Integer)iso.codingInds().a();
        int h = (Integer)iso.codingInds().b();
        for (int i = (int)reg.low(); i <= (int)reg.high(); ++i) {
            if (i == -1 || i < l || i > h) continue;
            int loc = i;
            if (!pv.containsKey(loc)) {
                pv.put(loc, 0);
            }
            pv.put(loc, (Integer)pv.get(loc) + 1);
        }
    }

    public int height(String chr, int loc) {
        if (!this.containsKey(chr)) {
            return 0;
        }
        HashMap pv = (HashMap)this.get(chr);
        if (!pv.containsKey(loc)) {
            return Math.max(Pileup.hh(pv, loc - 1), Pileup.hh(pv, loc + 1));
        }
        return (Integer)pv.get(loc);
    }

    private static int hh(HashMap<Integer, Integer> pv, int loc) {
        return pv.containsKey(loc) ? pv.get(loc) : 0;
    }

    public void writeToWig(String out) throws Exception {
        LandscapeBuilder lb = new LandscapeBuilder();
        for (String chr : this.keySet()) {
            HashMap pv = (HashMap)this.get(chr);
            ArrayList ps = new ArrayList();
            ps.addAll(pv.keySet());
            Collections.sort(ps);
            for (Integer p : ps) {
                GenomicRegion gr = new GenomicRegion(chr, p.intValue(), p.intValue());
                gr.setValue((double)((Integer)pv.get(p)).intValue());
                lb.add(gr);
            }
        }
        new BedGraphExporter((LandscapeBuffer)lb).writeToFile(out);
    }

    public double averageHeight(String chr, int low, int high) {
        double ret = 0.0;
        int len = 0;
        int[] poss = new int[]{low, high};
        for (int i = 0; i < poss.length; ++i) {
            int v = this.height(chr, poss[i]);
            if (v <= 0) continue;
            ret += (double)v;
            ++len;
        }
        return len == 0 ? 0.0 : ret / (double)len;
    }

    public int baseCount(GenomicRegion ... grs) {
        int ret = 0;
        for (GenomicRegion gr : grs) {
            String chr = gr.chr();
            if (!this.containsKey(chr)) continue;
            int low = (int)gr.low();
            int high = (int)gr.high();
            HashMap hm = (HashMap)this.get(chr);
            Iterator iterator = ((HashMap)this.get(chr)).keySet().iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                if (k < low || k > high) continue;
                ret += ((Integer)hm.get(k)).intValue();
            }
        }
        return ret;
    }

    public int baseCount(ArrayList<GenomicRegion> grs) {
        int ret = 0;
        for (GenomicRegion gr : grs) {
            ret += this.baseCount(gr);
        }
        return ret;
    }

    public ArrayList<GenomicRegion> coveredRegionsForGene(GenomicRegion greg) {
        ArrayList<GenomicRegion> ret = new ArrayList<GenomicRegion>();
        if (greg == null) {
            return ret;
        }
        String chr = greg.chr();
        int low = (int)greg.low();
        int high = (int)greg.high();
        if (!this.containsKey(chr)) {
            return ret;
        }
        HashMap hm = (HashMap)this.get(chr);
        int maxv = 0;
        Iterator iterator = hm.keySet().iterator();
        while (iterator.hasNext()) {
            int v;
            int k = (Integer)iterator.next();
            if (k < low || k > high || (v = ((Integer)hm.get(k)).intValue()) <= maxv) continue;
            maxv = v;
        }
        double thr = (double)maxv / 6.0;
        ArrayList ks = new ArrayList();
        ks.addAll(hm.keySet());
        Collections.sort(ks);
        int l = -1;
        int h = -1;
        Iterator iterator2 = ks.iterator();
        while (iterator2.hasNext()) {
            int k = (Integer)iterator2.next();
            if (k < low || k > high || (double)((Integer)hm.get(k)).intValue() < thr) continue;
            if (l == -1) {
                l = k;
                h = k;
                continue;
            }
            if (k == h + 1) {
                h = k;
                continue;
            }
            try {
                ret.add(new GenomicRegion(chr, l, h));
            }
            catch (Exception exception) {
                // empty catch block
            }
            l = k;
            h = k;
        }
        if (l != -1) {
            try {
                ret.add(new GenomicRegion(chr, l, h));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

