/*
 * Decompiled with CFR 0.152.
 */
package snippet.test;

import fork.lib.base.collection.Pair;
import fork.lib.base.collection.Table;
import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.bio.seq.CodonTranslator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import prog.core.aln.ele.IsoformStrand;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class DBMuts
extends HashMap<String, HashMap<String, HashMap<String, Pair<String, String>>>> {
    protected Index index;

    public DBMuts(Index index) {
        this.index = index;
    }

    private Pair<String, String> breakMut(String mut) {
        if (mut.contains("fs")) {
            return this.brs(mut, "fs");
        }
        if (mut.contains("ins")) {
            return this.brs(mut, "ins");
        }
        if (mut.contains("del")) {
            return this.brs(mut, "del");
        }
        try {
            String mid = mut.substring(1, mut.length() - 1);
            int loc = Integer.parseInt(mid);
            return new Pair((Object)mut.substring(0, mut.length() - 1), (Object)mut.substring(mut.length() - 1));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Pair<String, String> brs(String mut, String s) {
        int i = mut.indexOf(s);
        return new Pair((Object)mut.substring(0, i), (Object)mut.substring(i));
    }

    public void addCosmic(File f, String gene) throws Exception {
        ReadTable rt = new ReadTable(f);
        rt.param().setSkipRows(new int[]{0});
        rt.param().setSep(",");
        Table tab = rt.getTable();
        for (int i = 0; i < tab.size(); ++i) {
            Pair<String, String> br;
            ArrayList r = tab.getRow(i);
            String mut = ((String)r.get(18)).replace("p.", "").replace(" ", "_");
            String _clin = ((String)r.get(27)).replace(" ", "_");
            String clin = _clin.charAt(0) + _clin.substring(1).toLowerCase();
            String string = clin = clin.equals("null") ? "-" : clin;
            if (mut.contains("?") || (br = this.breakMut(mut)) == null) continue;
            this.addMut(gene, (String)br.a(), (String)br.b(), 0, clin);
        }
    }

    public void addSNP(File f, String gene) throws Exception {
        IsoformStrand iso = this.index.getGene(gene).isoforms().get(0).strandSense();
        String nuc = iso.sequence();
        String seq = new CodonTranslator(nuc.substring((Integer)iso.codingInds().a(), (Integer)iso.codingInds().b() + 1)).frame(0);
        ReadTable rt = new ReadTable(f);
        Table tab = rt.getTable();
        for (int i = 0; i < tab.size(); ++i) {
            ArrayList r = tab.getRow(i);
            String _mut = (String)r.get(12);
            int li = _mut.indexOf("[");
            int hi = _mut.indexOf("]");
            if (li == -1 || hi == -1) continue;
            String mut = _mut.substring(li + 1, hi);
            int loc = Integer.parseInt((String)r.get(14));
            char ori = seq.charAt(loc - 1);
            String clin = ((String)r.get(9)).replace(" ", "_");
            this.addMut(gene, ori + "" + loc, mut, 1, clin);
        }
    }

    private void addMut(String gene, String aa, String mut, int ab, String clin) {
        HashMap map2;
        HashMap map;
        if (!this.containsKey(gene)) {
            this.put(gene, new HashMap());
        }
        if (!(map = (HashMap)this.get(gene)).containsKey(aa)) {
            map.put(aa, new HashMap());
        }
        if (!(map2 = (HashMap)map.get(aa)).containsKey(mut)) {
            map2.put(mut, new Pair());
        }
        Pair p = (Pair)map2.get(mut);
        if (ab == 0) {
            p.setA((Object)clin);
        } else {
            p.setB((Object)clin);
        }
    }

    public void writeToFile(File out) throws Exception {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("Gene\tMutation\tCosmic\tdbSNP\n");
        for (String gene : this.keySet()) {
            ArrayList locs = new ArrayList();
            locs.addAll(((HashMap)this.get(gene)).keySet());
            Collections.sort(locs, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.compare(this.gl(o1), this.gl(o2));
                }

                protected int gl(String s) {
                    if (s.contains("_")) {
                        try {
                            return Integer.parseInt(s.substring(1, s.indexOf("_")));
                        }
                        catch (Exception e) {
                            return 0;
                        }
                    }
                    try {
                        return Integer.parseInt(s.substring(1));
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
            for (String loc : locs) {
                HashMap map = (HashMap)((HashMap)this.get(gene)).get(loc);
                for (String mut : map.keySet()) {
                    Pair p = (Pair)map.get(mut);
                    String va = p.a() == null ? "-" : (String)p.a();
                    String vb = p.b() == null ? "-" : (String)p.b();
                    bw.write(gene + "\t" + loc + mut + "\t" + va + "\t" + vb + "\n");
                }
            }
        }
        bw.close();
    }

    public static void main(String[] args) throws Exception {
        String dir = "C:\\muxingu\\data\\own\\SangerSoftware2\\file\\mut_meta";
        String indir = dir + "/db";
        Index index = IndexBuilder.read("C:/muxingu/data/own/SangerSoftware2/file/index.ind");
        String[] gns = new String[]{"CEBPA", "DNMT3A", "FLT3", "IDH1", "IDH2", "NPM1", "RUNX1", "TET2", "TP53"};
        DBMuts dd = new DBMuts(index);
        for (String gn : gns) {
            System.out.println("g:" + gn);
            File cf = new File(indir + "/cosmic_" + gn.toLowerCase() + ".csv");
            File sf = new File(indir + "/snp_" + gn.toLowerCase() + ".txt");
            dd.addCosmic(cf, gn);
            dd.addSNP(sf, gn);
        }
        dd.writeToFile(new File(dir + "/cosmic_dbsnp.txt"));
    }
}

