/*
 * Decompiled with CFR 0.152.
 */
package snippet.test;

import fork.lib.base.file.FileName;
import java.io.File;
import prog.core.Param;
import prog.core.aln.hot.DetectorFusion;
import prog.core.aln.hot.DetectorFusionPair;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.hot.DetectorITD;
import prog.core.aln.hot.VafCorrector;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;
import snippet.test.Summarise;

public class RunSamples {
    public static void main(String[] args) throws Exception {
        File[] fs;
        String root = "C:/muxingu/data/own/SangerSoftware2";
        File dir = new File(root + "/file");
        Param par = new Param();
        Index index = IndexBuilder.read(root + "/index_AML-26genes.ind");
        System.out.println("Index loaded. ");
        for (File f : fs = new File(dir + "/pool").listFiles()) {
            if (!FileName.extension((File)f).equals("rds") || f.getName().contains("test")) continue;
            String tag = FileName.baseName((File)f).replace("pool_", "");
            String alnpath = dir + "/pool/align_" + tag + ".aln";
            String poolpath = dir + "/pool/pool_" + tag + ".rds";
            ReadPool pool = ReadPool.read(poolpath);
            System.out.println(tag);
            AlignmentResult res2 = AlignmentResult.read(alnpath, index, pool);
            DetectorHotspot hs = new DetectorHotspot(res2, index, pool, par);
            hs.start();
            DetectorITD dd = new DetectorITD(res2, index, pool, par);
            dd.start();
            DetectorFusion ff = new DetectorFusion(res2, index, pool, par);
            ff.start();
            DetectorFusionPair fp = new DetectorFusionPair(res2, index, pool, par);
            fp.start();
            MutationResult mres = new MutationResult();
            mres.addAll(hs.result());
            mres.addAll(dd.result());
            mres.addAll(ff.result());
            mres.addAll(fp.result());
            MutationResult mutout = new MutationResult();
            for (MutationSpot mut : mres.allMutations()) {
                VafCorrector cor = new VafCorrector(mut, mut.reconstructedTranscripts(index, par.mostFrequencReadLength()), par);
                cor.build();
                cor.correct(res2, index, pool);
                mutout.addAll(cor.mutationResult());
            }
            MutationResult.writeToTxtFile(mutout, index, pool, dir + "/out_tcga/mut_correct/hotspot-corr_" + tag + ".txt", false);
        }
        Summarise.main(args);
    }
}

