/*
 * Decompiled with CFR 0.152.
 */
package snippet.test;

import fork.lib.base.collection.NamedTable;
import fork.lib.base.collection.Pair;
import fork.lib.base.collection.Table;
import fork.lib.base.file.FileName;
import fork.lib.base.file.io.txt.ReadTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import prog.core.aln.res.oncofilt.PathogenicityFilter;
import snippet.test.Sums;

public class Summarise {
    protected static String PREF = "mutation-onco_";
    protected static String PREF2 = "";
    protected static String METAB = "fab_class_.txt";
    protected static double THR1 = 0.05;
    protected static double THR2 = 0.096;
    protected static boolean IFPFILT = true;
    protected String dir;
    protected String outn;
    protected String d;
    static boolean ifAppendRef = true;
    protected static NamedTable<String, String, String> metab;
    protected static HashMap<String, HashMap<String, Pair<String, String>>> patho;
    protected ArrayList<Parser> pars = new ArrayList();
    protected File[] fs;
    public NamedTable<String, String, String> otab = new NamedTable();
    public static PathogenicityFilter pfilt;

    public Summarise(String dir) throws Exception {
        this.dir = dir;
        this.outn = FileName.baseName((String)dir);
        this.d = dir + "/mut_correct";
        this.fs = new File(this.d).listFiles();
        this.otab.DEFAULT = "-";
        metab = new ReadTable("C:\\muxingu/data/own/SangerSoftware2/file/mut_meta/" + METAB).getTable().toNamedTable();
    }

    private String tag(File fn) {
        return fn.getName().replace(PREF, "").replace(".txt", "");
    }

    public void addParser(Parser par) {
        this.pars.add(par);
    }

    public void start() throws Exception {
        for (File file : this.fs) {
            if (!file.getName().contains(PREF) || !file.getName().contains(PREF2)) continue;
            this.otab.appendEmptyRow((Object)this.tag(file));
        }
        for (Parser p : this.pars) {
            this.otab.appendEmptyColumn((Object)p.colnout);
            if (!ifAppendRef) continue;
            this.otab.appendColumn((Object)p.refcolnout, p.refcol);
        }
        for (File file : this.fs) {
            ReadTable rt = new ReadTable(file);
            rt.setSkipRows(new int[]{0});
            Table tab = rt.getTable();
            String tag = this.tag(file);
            for (int i = 0; i < tab.rowNumber(); ++i) {
                ArrayList r = tab.getRow(i);
                String gene = (String)r.get(0);
                String loc = (String)r.get(1);
                String aa = (String)r.get(2);
                String mut = (String)r.get(3);
                String wt = (String)r.get(4);
                String vaf = (String)r.get(5);
                for (Parser par : this.pars) {
                    if (!par.ifadd(gene, loc, aa, wt, mut, vaf)) continue;
                    String nv = par.value(gene, loc, aa, wt, mut, vaf);
                    String ov = (String)this.otab.getValueAt((Object)tag, (Object)par.colnout);
                    if (ov == null) {
                        this.otab.setValueAt((Object)nv, (Object)tag, (Object)par.colnout);
                        continue;
                    }
                    this.otab.setValueAt((Object)(ov + ",," + nv), (Object)tag, (Object)par.colnout);
                }
            }
        }
    }

    public static ArrayList<String> selectAA(String refcoln, String tar, boolean contain) {
        ArrayList vs = metab.getColumn((Object)refcoln);
        ArrayList<String> ret = new ArrayList<String>();
        for (String v : vs) {
            String addv = "";
            for (String s : v.split(",")) {
                if (!(contain ? s.contains(tar) : !s.contains(tar))) continue;
                addv = addv + s;
            }
            ret.add(addv.equals("") ? "-" : addv);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String tag = "leu_dek";
        ifAppendRef = false;
        String dir = "C:\\muxingu/data/own/SangerSoftware2/file/out_" + tag;
        Summarise ss = new Summarise(dir);
        ss.addParser(new Parserf(new String[]{"DEK-NUP214", "NUP214-DEK"}, "DEK-NUP214", "DEK.NUP214", "DEK-NUP214_Ref"));
        ss.addParser(new Parserf(new String[]{"PML-RARA", "RARA-PML"}, "PML-RARA", "PML.RARA", "PML-RARA_Ref"));
        ss.addParser(new Parserf(new String[]{"CBFB-MYH11", "MYH11-CBFB"}, "MYH11-CBFB", "MYH11.CBFB", "MYH11-CBFB_Ref"));
        ss.addParser(new Parserf(new String[]{"RUNX1-RUNX1T1", "RUNX1T1-RUNX1"}, "RUNX1-RUNX1T1", "RUNX1.RUNX1T1", "RUNX1-RUNX1T1_Ref"));
        ss.addParser(Sums.MLL_FUSION);
        ss.addParser(new Parserf(new String[]{"BCR-ABL1", "ABL1-BCR"}, "BCR-ABL1", "BCR.ABL", "BCR-ABL1_Ref"));
        ss.addParser(new Parserf(new String[]{"NSD1-NUP98", "NUP98-NSD1"}, "NUP98-NSD1", "NUP98.NSD1", "NUP98-NSD1_Ref"));
        ss.addParser(Sums.NPM1);
        ss.addParser(Sums.FLT3ITD);
        ss.addParser(Sums.MLLPTD);
        ss.addParser(Sums.FLT3);
        ss.addParser(Sums.CEBPA);
        ss.addParser(Sums.DNMT3A);
        ss.addParser(Sums.IDH1);
        ss.addParser(Sums.IDH2);
        ss.addParser(Sums.RUNX1);
        ss.addParser(Sums.TP53);
        ss.addParser(Sums.TET2);
        ss.addParser(Sums.WT1);
        ss.addParser(Sums.BCOR);
        ss.addParser(Sums.ASXL1);
        ss.addParser(Sums.SRSF2);
        ss.addParser(Sums.SF3B1);
        ss.addParser(Sums.U2AF1);
        ss.start();
        ss.otab.writeToFile(dir + "/summary_" + tag + ".txt");
    }

    static {
        patho = new HashMap();
        try {
            pfilt = new PathogenicityFilter("C:\\muxingu/data/own/SangerSoftware2/oncogenicity_filter.txt");
            Table tt = new ReadTable("C:\\muxingu/data/own/SangerSoftware2/file/mut_meta/cosmic_dbsnp.txt").getTable();
            for (int i = 0; i < tt.rowNumber(); ++i) {
                ArrayList r = tt.getRow(i);
                String g = (String)r.get(0);
                String m = (String)r.get(1);
                if (m.contains("*")) {
                    m = m.substring(0, m.indexOf("*"));
                }
                if (!patho.containsKey(g)) {
                    patho.put(g, new HashMap());
                }
                patho.get(g).put(m, (Pair<String, String>)new Pair(r.get(2), r.get(3)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static class Parserf
    extends Parser {
        public Parserf(String[] scols, String col, String refcol, String refcolout) {
            super(scols, col, refcol, refcolout);
        }

        @Override
        protected boolean ifvaf(String mut, String vafstr) {
            return true;
        }

        @Override
        protected boolean ifmutgood(String loc, String aa, String gene) {
            return true;
        }

        @Override
        public String value(String gene, String loc, String aa, String wt, String mut, String vaf) {
            if (aa.equals("PE")) {
                return gene + "_" + aa + "_" + mut + "_" + wt;
            }
            return aa + "_" + mut + "_" + wt;
        }
    }

    public static class Parser {
        protected HashSet<String> cols = new HashSet();
        public String colnout;
        public String refcoln;
        public String refcolnout;
        public ArrayList<String> refcol = new ArrayList();

        Parser(String[] scols, String col, String refcoln, String refcolout) {
            this.colnout = col;
            this.refcoln = refcoln;
            this.refcolnout = refcolout;
            this.cols.addAll(Arrays.asList(scols));
            this.initRefcol();
            for (String v : this.refcol) {
                for (String g : v.split(",")) {
                    String xx;
                    String g_ = g.replace("p.", "");
                    if (!g_.contains(xx = "in_frame_ins")) continue;
                    g_ = g_.substring(0, g_.indexOf(xx) + xx.length());
                }
            }
        }

        Parser(String s) {
            this(new String[]{s}, s, s, s + "_Ref");
        }

        protected void initRefcol() {
            System.out.println(this.refcoln);
            if (ifAppendRef) {
                this.refcol = metab.getColumn((Object)this.refcoln);
            }
        }

        protected boolean ishotspot(String aa, String vs) {
            return false;
        }

        protected boolean ifvaf(String aa, String vs) {
            double v = Double.parseDouble(vs);
            if (aa.contains("fs") || aa.contains("Ins")) {
                return v > THR1;
            }
            if (aa.contains("*")) {
                return v > THR1;
            }
            return v > THR2;
        }

        protected boolean ifmutgood(String loc, String aa, String gene) {
            if (IFPFILT) {
                if (pfilt.isExplicit(gene, aa)) {
                    return true;
                }
                return pfilt.isGood(gene, aa);
            }
            return true;
        }

        public boolean ifadd(String gene, String loc, String aa, String wt, String mut, String vaf) {
            return this.cols.contains(gene) && this.ifmutgood(loc, aa, gene) && this.ifvaf(aa, vaf);
        }

        public String value(String gene, String loc, String aa, String wt, String mut, String vaf) {
            return aa + "_" + vaf;
        }
    }
}

