/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.gui.soft.gen.comp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JFrame;

public class Positioner {
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private GraphicsDevice[] gdevs;

    public Positioner() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.gdevs = ge.getScreenDevices();
    }

    public Dimension screenSize() {
        return this.screenSize;
    }

    public void positionAtScreenCentre(Component c) {
        int x = this.centre(c.getSize().width, this.screenSize.width);
        int y = this.centre(c.getSize().height, this.screenSize.height);
        c.setLocation(x, y);
    }

    public void setWindowSizeRelativeToScreen(Component c, double facx, double facy) {
        int x = (int)Math.round((double)this.screenSize.width * facx);
        int y = (int)Math.round((double)this.screenSize.height * facy);
        c.setSize(new Dimension(x, y));
    }

    private int centre(int ol, int scl) {
        if (ol >= scl) {
            return 0;
        }
        return (scl - ol) / 2;
    }

    public void positionNextTo(Component c, Component ref) {
        int x = ref.getLocation().x;
        int y = ref.getLocation().y;
        c.setLocation(x + 20, y + 20);
    }

    public void positionAtCentreWithFactor(Component c, Component ref, double fx, double fy) {
        int x = ref.getLocation().x;
        int y = ref.getLocation().y;
        int cx = x + (int)((double)(ref.getSize().width - c.getSize().width) * fx);
        int cy = y + (int)((double)(ref.getSize().height - c.getSize().height) * fy);
        c.setLocation(cx, cy);
    }

    public void positionAtCentreOf(Component c, Component ref) {
        this.positionAtCentreWithFactor(c, ref, 0.5, 0.5);
    }

    public static void main(String[] args) throws Exception {
        Logger ll = Logger.getLogger("aaa");
        System.out.println(ll.getName());
        FileHandler hh = new FileHandler("log.txt");
        ll.addHandler(hh);
        hh.setFormatter(new SimpleFormatter());
        ll.setUseParentHandlers(false);
        for (int i = 0; i < 100; ++i) {
            ll.info("ind " + i);
        }
        System.exit(1);
        Positioner ps = new Positioner();
        JFrame win = new JFrame();
        ps.setWindowSizeRelativeToScreen(win, 0.8, 0.8);
        ps.positionAtScreenCentre(win);
        win.setDefaultCloseOperation(3);
        win.setVisible(true);
    }
}

