/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.gui.soft.gen.util;

import java.io.File;

public abstract class Checker {
    public static char MODE_ERROR = (char)101;
    public static char MODE_WARNING = (char)119;
    protected String errMsg = "";
    protected String warningMsg = "";

    public static void checkFileExit(Checker c, String path, char mode, String pref) {
        File f = new File(path);
        if (!f.exists()) {
            if (mode == MODE_ERROR) {
                if (pref != null) {
                    c.appendErrorMessage(pref + " " + f.getAbsolutePath() + "\n");
                } else {
                    c.appendErrorMessage("File not exist: " + f.getAbsolutePath() + "\n");
                }
            } else if (mode == MODE_WARNING) {
                if (pref != null) {
                    c.appendWarningMessage(pref + " " + f.getAbsolutePath() + "\n");
                } else {
                    c.appendWarningMessage("File not exist: " + f.getAbsolutePath() + "\n");
                }
            }
        }
    }

    public abstract void check();

    public void appendErrorMessage(String m) {
        this.errMsg = this.errMsg + m;
    }

    public void appendWarningMessage(String m) {
        this.warningMsg = this.warningMsg + m;
    }

    public String errorMessage() {
        return this.errMsg;
    }

    public String warningMessage() {
        return this.warningMsg;
    }

    public boolean ifError() {
        return !this.errMsg.equals("");
    }

    public boolean ifWarning() {
        return !this.warningMsg.equals("");
    }
}

