/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.gui.soft.gen.util;

import java.util.ArrayList;

public abstract class FAnalysis {
    protected final FAnalysis parent;
    protected ArrayList<FAnalysis> children = new ArrayList();
    protected FAnalysis curChild;
    protected String tit;
    protected String saveTit;

    protected abstract void destroy();

    public abstract void reloadComponents();

    public abstract void render();

    public FAnalysis(FAnalysis parent) {
        this.parent = parent;
        if (parent != null) {
            parent.curChild = this;
            this.parent.children.add(this);
        } else {
            this.curChild = this;
        }
    }

    public FAnalysis getParent() {
        return this.parent;
    }

    public FAnalysis getCurrentChild() {
        return this.curChild;
    }

    public String getTitle() {
        return this.tit;
    }

    public String getSaveTitle() {
        return this.saveTit;
    }

    public void setTitle(String tit) {
        this.tit = tit;
    }

    public void setSaveTitle(String tit) {
        this.saveTit = tit;
    }

    public ArrayList<FAnalysis> children() {
        return this.children;
    }

    public String helpMsg() {
        return "";
    }

    public ArrayList<FAnalysis> getHierarchy() {
        ArrayList<FAnalysis> ret = new ArrayList<FAnalysis>();
        FAnalysis a = this;
        do {
            ret.add(a);
        } while ((a = a.parent) != null);
        return ret;
    }

    public ArrayList<FAnalysis> getAllChildren() {
        ArrayList<FAnalysis> ret = new ArrayList<FAnalysis>();
        FAnalysis.collectChildren(ret, this);
        return ret;
    }

    private static void collectChildren(ArrayList<FAnalysis> chs, FAnalysis an) {
        if (an.children().isEmpty()) {
            return;
        }
        for (FAnalysis c : an.children()) {
            FAnalysis.collectChildren(chs, c);
        }
    }

    public FAnalysis getTopParent() {
        FAnalysis ret = this;
        while (ret.getParent() != null) {
            ret = ret.getParent();
        }
        return ret;
    }

    public ArrayList<FAnalysis> getCompetitors() {
        if (this.parent == null) {
            return new ArrayList<FAnalysis>();
        }
        if (this.children != null) {
            ArrayList<FAnalysis> ret = new ArrayList<FAnalysis>();
            for (FAnalysis c : this.children) {
                if (c == null || c.equals(this)) continue;
                ret.add(c);
            }
            return ret;
        }
        return new ArrayList<FAnalysis>();
    }

    public void destroyCompetitors() {
        for (FAnalysis c : this.getCompetitors()) {
            c.destroy();
            c.destroyChildren();
        }
    }

    public void destroyChildren() {
        for (FAnalysis s : this.children) {
            s.destroyChildren();
        }
    }

    public void destroyCompetitorChain() {
        this.destroyCompetitors();
        if (this.parent != null) {
            this.parent.destroyCompetitorChain();
        }
    }

    private void updateChildChain() {
        if (this.curChild == null) {
            this.curChild = this;
        }
        if (this.parent != null) {
            this.parent.curChild = this.curChild;
        }
    }

    public void reRenderChain() {
        this.destroyCompetitorChain();
        this.reloadComponents();
        this.updateChildChain();
        this.render();
        if (this.parent != null) {
            this.parent.reRenderChain();
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

