/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.gui.soft.gen.util.init;

import fork.lib.gui.soft.gen.util.Checker;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class FInitChecker
extends Checker {
    protected static final String ERR_PREF = "Critical Error";
    protected static final String ERR_SUF = "Please check or re-download the program.";
    protected static final String WARN_PREF = "Warning";
    protected static final String WARN_SUF = "Do you wish to continue?";
    protected int maxShowErr = 15;
    protected int maxShowWarn = 15;
    protected ArrayList<String> essentialPaths = new ArrayList();
    protected ArrayList<String> recomPaths = new ArrayList();
    protected int essentialMemory = 512;
    protected int recomMemory = 1024;
    protected int essentialDisk = 128;
    protected int recomDisk = 256;

    @Override
    public void check() {
        this.checkMemory();
        this.checkFiles();
    }

    private static int toMB(long v) {
        return (int)Math.floor((double)v / 1000000.0);
    }

    public void setEssentialMemory(int m) {
        this.essentialMemory = m;
    }

    public void setRecommendedMemory(int m) {
        this.recomMemory = m;
    }

    public void setEssentialDiskSpace(int m) {
        this.essentialDisk = m;
    }

    public void setRecommendedDiskSpace(int m) {
        this.recomDisk = m;
    }

    protected void checkFiles() {
        ArrayList<File> efs = new ArrayList<File>();
        for (String p : this.essentialPaths) {
            File f = new File(p);
            if (f.exists()) continue;
            efs.add(f);
        }
        if (!efs.isEmpty()) {
            this.appendErrorMessage("Essential files are not found:\n");
            for (File f : efs) {
                this.appendErrorMessage("    " + f.getAbsolutePath() + "\n");
            }
        }
        ArrayList<File> rfs = new ArrayList<File>();
        for (String p : this.recomPaths) {
            File f = new File(p);
            if (f.exists()) continue;
            rfs.add(f);
        }
        if (!rfs.isEmpty()) {
            this.appendWarningMessage("Optional files are not found:\n");
            for (File f : rfs) {
                this.appendWarningMessage("    " + f.getAbsolutePath() + "\n");
            }
        }
    }

    public void addEssentialPaths(String ... ps) {
        for (String p : ps) {
            if (this.essentialPaths.contains(p)) continue;
            this.essentialPaths.add(p);
        }
    }

    public void addRecommendedPaths(String ... ps) {
        for (String p : ps) {
            if (this.recomPaths.contains(p)) continue;
            this.recomPaths.add(p);
        }
    }

    protected void checkMemory() {
        int fd;
        int fm = FInitChecker.toMB(Runtime.getRuntime().totalMemory());
        if (fm < this.essentialMemory) {
            this.appendErrorMessage("Allocated memory: " + fm + "MB is smaller than required: " + this.essentialMemory + "MB\nPlease restart with provided .bat or .sh scripts or use -Xms" + this.essentialMemory + "m -Xmx" + this.essentialMemory + "m flags.");
        }
        if (fm < this.recomMemory) {
            this.appendWarningMessage("Allocated memory: " + fm + "MB is smaller than recommended: " + this.recomMemory + "MB\n");
        }
        if ((fd = FInitChecker.toMB(new File(System.getProperty("user.dir")).getFreeSpace())) < this.essentialDisk) {
            this.appendErrorMessage("Free disk space: " + fm + "MB is less than required: " + this.essentialDisk + "MB\n");
        }
        if (fd < this.recomMemory) {
            this.appendWarningMessage("Free disk space: " + fm + "MB is less than required: " + this.recomDisk + "MB\n");
        }
    }

    private String finalMessage(String m, int ml, String pref, String suf) {
        String ret = "";
        String[] ss = m.split("\n");
        for (int i = 0; i < Math.min(ss.length, ml); ++i) {
            ret = ret + ss[i] + "\n";
        }
        ret = ret + "\n" + suf + "\n";
        return ret;
    }

    public String finalErrorMessage() {
        return this.finalMessage(this.errMsg, this.maxShowErr, ERR_PREF, ERR_SUF);
    }

    public String finalWarningMessage() {
        return this.finalMessage(this.warningMsg, this.maxShowWarn, WARN_PREF, WARN_SUF);
    }

    public void showErrorMessageAndDie() {
        if (this.ifError()) {
            JOptionPane.showMessageDialog(null, this.finalErrorMessage(), ERR_PREF, 0);
            System.exit(1);
        }
    }

    public boolean showWarningMessageAndConfirm() {
        if (this.ifWarning()) {
            int r = JOptionPane.showConfirmDialog(null, this.finalWarningMessage(), WARN_PREF, 0, 2);
            return r == 0;
        }
        return true;
    }
}

